/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.util.Trace;
import java.util.GregorianCalendar;

public class InterruptionThread
implements Runnable {
    private static final String TRACE_MASKD = "XCRTINTD";
    private static final String TRACE_MASKF = "XCRTINTF";
    private static final String TRACE_MASKT = "XCRTINTT";
    private long timeout = 0L;
    private Thread thread = null;
    private boolean terminate = false;
    private boolean done = false;

    public InterruptionThread(Thread thread, long timeout) {
        this.thread = thread;
        this.timeout = timeout;
        Trace.trace(TRACE_MASKT, "<->InterruptionThread(" + thread + ", " + timeout + ")");
    }

    public static void main(String[] args) {
    }

    public boolean isDone() {
        return this.done;
    }

    public synchronized void setTerminate() {
        this.terminate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        long currentTime = 0L;
        while ((currentTime = new GregorianCalendar().getTimeInMillis()) < this.timeout) {
            try {
                Thread.currentThread();
                Thread.sleep(this.timeout - currentTime);
            }
            catch (InterruptedException e) {
                InterruptionThread interruptionThread = this;
                // MONITORENTER : interruptionThread
                if (this.terminate) {
                    Trace.trace(TRACE_MASKF, "Requested to terminate");
                    // MONITOREXIT : interruptionThread
                    Trace.trace(TRACE_MASKF, "Terminating");
                    this.done = true;
                    return;
                }
                // MONITOREXIT : interruptionThread
            }
        }
        Trace.trace(TRACE_MASKF, "Timeout exceeded");
        this.done = true;
        Trace.trace(TRACE_MASKF, "Interrupting");
        this.thread.interrupt();
        return;
        finally {
            Trace.trace(TRACE_MASKF, "Terminating");
            this.done = true;
        }
    }
}

